#ifndef CGEN2SIMPLETAGDIALOG_H
#define CGEN2SIMPLETAGDIALOG_H

#include <QDialog>
#include <ui_CGen2SimpleTagDialog.h>
#include "../../ui/ConfigDialog.h"

#include <QrfeReaderInterfaceGlobal>
#include <tag/QrfeGen2Tag>

class CGen2KillDialog;
class CGen2LockDialog;

class CGen2SimpleTagDialog : public QDialog, ConfigDialog
{
    Q_OBJECT

public:
    CGen2SimpleTagDialog(QWidget *parent = 0);
    ~CGen2SimpleTagDialog();

public slots:
	int exec ( QrfeReaderInterface* ph, QString tagId, uint antennaId );
	virtual void done(int r);

	void read();
	void write();
	void lock();
	void kill();

	void paramsChanged();

private:
    Ui::CGen2SimpleTagDialogClass ui;

	QrfeReaderInterface* 			m_reader;
	QrfeGen2Tag*					m_tag;
	uint 							m_antennaId;

	CGen2KillDialog* 				m_killDialog;
	CGen2LockDialog* 				m_lockDialog;
};

#endif // CGEN2SIMPLETAGDIALOG_H
